//---------------------------------------------------------------------------

#ifndef powerdaq_ainH
#define powerdaq_ainH
//---------------------------------------------------------------------------
#include <System.Classes.hpp>
#include <Vcl.Controls.hpp>
#include <Vcl.StdCtrls.hpp>
#include <Vcl.Forms.hpp>

#include "pwrdaq32.h"
#include "pwrdaq.h"
#include "pdfw_def.h"
#include "pd_hcaps.h"
#include "iScope.hpp"
#include "iComponent.hpp"
#include "iCustomComponent.hpp"
#include "iPlot.hpp"
#include "iPlotComponent.hpp"
#include "iVCLComponent.hpp"
#include "LPControlDrawLayers.h"
#include "SLControlCollection.h"
#include "SLScope.h"
#include "VCL.LPControl.h"
#include "iLabel.hpp"
#include "iModeComboBox.hpp"
#include "iSwitchLed.hpp"
#include <Vcl.ComCtrls.hpp>
#include <IdBaseComponent.hpp>
#include <IdComponent.hpp>
#include <IdContext.hpp>
#include <IdCustomTCPServer.hpp>
#include <IdTCPServer.hpp>

typedef enum _state
{
   closed,
	  unconfigured,
	  configured,
	  running
} tState;

typedef struct _bufferedAiData
{
   int abort;
   int board;                    // board number to be used for the AI operation
   unsigned long nbOfBoards;     // number of boards installed
   HANDLE handle;                // board handle
   HANDLE driver;
   unsigned short *rawBuffer;    // address of the buffer allocated by the driver to store
								 // the raw binary data
   int nbOfChannels;             // number of channels
   DWORD channelList[64];
   int nbOfFrames;               // number of frames used in the asynchronous circular buffer
   int nbOfSamplesPerChannel;    // number of samples per channel
   double scanRate;              // sampling frequency on each channel
   double maxRate;
   int polarity;                 // polarity of the signal to acquire, possible value
								 // is AIN_UNIPOLAR or AIN_BIPOLAR
   int range;                    // range of the signal to acquire, possible value
								 // is AIN_RANGE_5V or AIN_RANGE_10V
   int inputMode;                // input mode possible value is AIN_SINGLE_ENDED or AIN_DIFFERENTIAL
   int trigger;
   unsigned long Error;
   HANDLE hNotifyEvent;
   tState state;                 // state of the acquisition session
} tBufferedAiData;


class TPowerDaqThread : public TThread
{
	public:
	  __fastcall TPowerDaqThread(void);
	  double __fastcall TPowerDaqThread::GetNoise(double Magnitude);

	  tBufferedAiData AiData;
      String Message;

	private:
	  void __fastcall Execute(void);
	  void __fastcall UpdateDisplay(void);
	  void __fastcall UpdateDisplayReal(void);
	  void __fastcall MemoMessage(void);
	  void __fastcall TPowerDaqThread::BufferedAI(tBufferedAiData *pAiData, double *buffer);
};

//---------------------------------------------------------------------------
class TForm1 : public TForm
{
__published:	// IDE-managed Components
	TButton *Button1;
	TMemo *Memo1;
	TButton *Button2;
	TiPlot *iPlot2;
	TiPlot *iPlot3;
	TiPlot *iPlot1;
	TiModeComboBox *iModeComboBox1;
	TiSwitchLed *iSwitchLed1;
	TStatusBar *StatusBar1;
	TIdTCPServer *IdTCPServer1;
	void __fastcall Button1Click(TObject *Sender);
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall FormDestroy(TObject *Sender);
	void __fastcall Button2Click(TObject *Sender);
	void __fastcall iPlot1LimitLine1PositionChange(int Index, double OldValue, double NewValue);
	void __fastcall iPlot2LimitLine1PositionChange(int Index, double OldValue, double NewValue);
	void __fastcall iPlot3LimitLine1PositionChange(int Index, double OldValue, double NewValue);
	void __fastcall IdTCPServer1Execute(TIdContext *AContext);

private:	// User declarations


public:		// User declarations
	TPowerDaqThread *pdThread;
	HANDLE AcquireEvent;
	int Running;
	double *buffer;
	__fastcall TForm1(TComponent* Owner);
	__fastcall TForm1::InitBufferedAI(tBufferedAiData *pAiData);
	__fastcall TForm1::ReleaseBufferedAI(tBufferedAiData *pAiData);
};
//---------------------------------------------------------------------------
extern PACKAGE TForm1 *Form1;
//---------------------------------------------------------------------------


#endif
