#
# FILE
#   calib2_loaders.tcl
#
# PROTOCOL
#   emcalib/calib2
#
# DESCRIPTION
#   Define training protocol for emcalib
#
# AUTHOR
#   DLS
#


namespace eval calib2 {
    proc setup_9point { scale fix_size nreps } {
	setup_stimdg 9 $scale $fix_size $nreps bullseye
    }

    proc setup_9point_spin { scale fix_size nreps } {
	setup_stimdg 9 $scale $fix_size $nreps spinning
    }

    proc setup { npoints scale fix_size nreps } {
	setup_stimdg $npoints $scale $fix_size $nreps bullseye
    }

    proc setup_stimdg { npoints scale fix_size nreps type } {
	if {[dg_exists stimdg]} { dg_delete stimdg }
	dg_create stimdg
	dl_set stimdg:version [dl_slist [namespace current]]
	
	if { $npoints == 9 } {
	    dl_local series [dl_series -1 1]
	    set n [dl_length $series]
	    dl_local x [dl_replicate [dl_replicate $series $n] $nreps]
	    dl_local y [dl_replicate [dl_repeat $series $n] $nreps]
	    dl_local x [dl_mult $x $scale]
	    dl_local y [dl_mult $y $scale]
	}

	# leave the center (we used to eliminate)

	set nstims [dl_length $x]
	dl_set stimdg:id [dl_fromto 0 $nstims]
	dl_set stimdg:jump_x $x
	dl_set stimdg:jump_y $y
	

	dl_set stimdg:scale [dl_repeat $fix_size $nstims]
	dl_set stimdg:type [dl_repeat [dl_slist $type] $nstims]
	dl_set stimdg:remaining [dl_ones $nstims]
    }
}
