#####################################################################
#
#  NAME
#   do_calibration.tcl    
#
#  DESCRIPTION
#   load data from dgz files and calculate calibration transformation
#
#####################################################################
package require dlsh
package require loaddata
package require emcalib
package require stimctrl
package require dgserver
package require qpcs

set QNXHost ""

# Get subject codes
array unset subject_table *
array set subject_table \
    [list b_ buzz d_ dante e_ eddy  y_ murphy w_ walt f_ flynn g_ gallagher i_ issac j_ jack \
	 h_ thor c_ jesse a_ abraham l_ glenn m_ max o_ oliver r_ regi s_ simon t_ tiger x_ dexter human_ human]

proc QNXCmd { cmd } {
    global QNXHost
    if { $QNXHost == "" || $cmd == "" } { return }
    
    set return [eval qpcs::sendToQNX $QNXHost \
		    catch [list $cmd] result]
    if {$return == ""} {
	puts "QNXCmd:   $cmd"
	puts "   \$return failed = $return"
	set return [eval qpcs::sendToQNX $QNXHost \
			catch [list $cmd] result]
    }
    
    set error [lindex $return 1]
    set result [eval qpcs::sendToQNX $QNXHost \
		    set result]
    regsub ":" $result "" result
    
    if {[lindex $return 0] == -1 || [lindex $result 0] == -1 || $error } {
	error "a sendToQNX command failed.  check Host."
	return -1
    }
 
    return [lrange $result 1 end]
}

proc setup { pattern } {
    set start 250
    set stop 600
    calibview::setup 1
    set calibview::emStartTime $start
    set calibview::emStopTime $stop

    set ::calibview::forwardTo $::QNXHost

    calibview::loadFile $pattern
}

set pattern [lindex $argv 0]
if { [expr $argc > 1] } { 
    set ::QNXHost [lindex $argv 1]
}

if { $::QNXHost != "" } { 
    set subject [string range $::pattern 0 1]

    # if we don't know who it is, then we call them a human subject
    if {[lsearch [array names subject_table] $subject] == -1} { 
	set subject human_ 
    }

    QNXCmd "cd /shared/lab/projects/encounter/data/$::subject_table($subject)"
    QNXCmd "exec convdata '$pattern'"
}

proc update_coeffs {} {
    global QNXHost
    if { $QNXHost != "" } {
	# Put fit onto QNX host
	dgserver::put $::QNXHost $calibview::fitDG em_coeffDG
    }
}


setup $pattern

