#####################################################################
#
#  NAME
#   do_calibration.tcl    
#
#  DESCRIPTION
#   load data from dgz files and calculate calibration transformation
#
#####################################################################
package require dlsh
package require loaddata
package require emcalib
package require stimctrl
package require dgserver
package require qpcs

set QNXHost ""

proc QNXCmd { cmd } {
    global QNXHost
    if { $QNXHost == "" || $cmd == "" } { return }
    
    set return [eval qpcs::sendToQNX $QNXHost \
		    catch [list $cmd] result]
    if {$return == ""} {
	puts "QNXCmd:   $cmd"
	puts "   \$return failed = $return"
	set return [eval qpcs::sendToQNX $QNXHost \
			catch [list $cmd] result]
    }
    
    set error [lindex $return 1]
    set result [eval qpcs::sendToQNX $QNXHost \
		    set result]
    regsub ":" $result "" result
    
    if {[lindex $return 0] == -1 || [lindex $result 0] == -1 || $error } {
	error "a sendToQNX command failed.  check Host."
	return -1
    }
 
    return [lrange $result 1 end]
}

set pattern rx_emcalib9_111713001
set QNXHost beast.neuro.brown.edu
QNXCmd "cd /shared/lab/projects/encounter/data/human"
QNXCmd "exec convdata '$pattern'"

