#
# FILE
#   movie_loaders.tcl
#
# PROTOCOL
#   emcalib/movie
#
# DESCRIPTION
#   Define training protocol for emcalib
#
# AUTHOR
#   DLS
#


namespace eval movie {
    proc setup_cardinal { incr scale { dirs 2 } } {
	if {[dg_exists stimdg]} { dg_delete stimdg }
	dg_create stimdg
	dl_set stimdg:version [dl_slist [namespace current]]

	switch -exact $dirs {
	    2 {
		dl_local x [dl_repeat \
			[dl_mult [dl_ilist -2 -1 1 2 0 0 0 0] $incr] 8]
		dl_local y [dl_repeat \
			[dl_mult [dl_ilist 0 0 0 0 -2 -1 1 2] $incr] 8]
	    }
	    1 {
		dl_local x [dl_repeat \
			[dl_mult [dl_ilist 0 0 0 0] $incr] 16]
		dl_local y [dl_repeat \
			[dl_mult [dl_ilist -2 -1 1 2] $incr] 16]
	    }
	    3 {
		dl_local x [dl_repeat \
			[dl_mult [dl_ilist -2 2 0 0] $incr] 8]
		dl_local y [dl_repeat \
			[dl_mult [dl_ilist 0 0 -2 2] $incr] 8]
	    }
	    default {
		dl_local y [dl_repeat \
			[dl_mult [dl_ilist 0 0 0 0] $incr] 16]
		dl_local x [dl_repeat \
			[dl_mult [dl_ilist -2 -1 1 2] $incr] 16]
	    }
	}

	dl_local v [dl_not [dl_and [dl_eq $x 0] [dl_eq $y 0]]]
	dl_local x [dl_select $x $v]
	dl_local y [dl_select $y $v]
	dl_set stimdg:jump_x [dl_replicate $x 2]
	dl_set stimdg:jump_y [dl_replicate $y 2]
	
	set nstims [dl_length stimdg:jump_x]

	dl_set stimdg:scale [dl_repeat $scale $nstims]
	dl_set stimdg:id [dl_fromto 0 $nstims]
	dl_set stimdg:remaining [dl_ones $nstims]

	dl_local clips [eval dl_slist [get_clips]]
	dl_set stimdg:clip [dl_choose $clips \
				[dl_irand $nstims [dl_length $clips]]]
    }

    proc setup_9point { incr fix_size } {
	set rep 2
	if {[dg_exists stimdg]} { dg_delete stimdg }
	dg_create stimdg
	dl_set stimdg:version [dl_slist [namespace current]]

	dl_local series [dl_flist -1. 0. 1]
	set n [dl_length $series]
	dl_local x [dl_replicate [dl_replicate $series $n] $rep]
	dl_local y [dl_replicate [dl_repeat $series $n] $rep]
	dl_local x [dl_mult $x $incr]
	dl_local y [dl_mult $y $incr]

	set nstims [dl_length $x]
	dl_set stimdg:id [dl_fromto 0 $nstims]
	dl_set stimdg:jump_x $x
	dl_set stimdg:jump_y $y

	dl_set stimdg:scale [dl_repeat $fix_size $nstims]
	dl_set stimdg:remaining [dl_ones $nstims]

	dl_local clips [eval dl_slist [get_clips]]
	dl_set stimdg:clip [dl_choose $clips \
				[dl_irand $nstims [dl_length $clips]]]
    }

    proc setup_24point { incr fix_size } {
	if {[dg_exists stimdg]} { dg_delete stimdg }
	dg_create stimdg
	dl_set stimdg:version [dl_slist [namespace current]]

	dl_local series [dl_series -4 4]
	set n [dl_length $series]
	dl_local x [dl_replicate [dl_replicate $series $n] 2]
	dl_local y [dl_replicate [dl_repeat $series $n] 2]
	dl_local x [dl_mult $x $incr]
	dl_local y [dl_mult $y $incr]

	dl_local v [dl_and \
			[dl_not [dl_and [dl_eq $x 0] [dl_eq $y 0]]] \
			[dl_lt [dl_abs $y] 8.]]
		    
	dl_local x [dl_select $x $v]
	dl_local y [dl_select $y $v]

	set nstims [dl_length $x]
	dl_set stimdg:id [dl_fromto 0 $nstims]
	dl_set stimdg:jump_x $x
	dl_set stimdg:jump_y $y
	

	dl_set stimdg:scale [dl_repeat $fix_size $nstims]
	dl_set stimdg:remaining [dl_ones $nstims]

	dl_local clips [eval dl_slist [get_clips]]
	dl_set stimdg:clip [dl_choose $clips \
				[dl_irand $nstims [dl_length $clips]]]
    }

    proc get_clips { } {
	return "cat mother_and_baby tanzaniachimps treejumping big_brains eating gibbons gorilla grooming hanging jumping"
    }
}
