#
# FILE
#   movie_variants.tcl
#
# PROTOCOL
#   emcalib/movie
#
# DESCRIPTION
#   Define calibration protocol for emcalib task
#
# AUTHOR
#   DLS
#
# LAST MODIFIED
#  2/02
#

namespace eval movie {
    # ---------------------------------------------------------------------
    # Variant Definitions
    # format { {display name} {loader proc}
    #          {shortname for defaults,init,destroy} {display description} }
    set variants { 
	{ {9point calibration} setup_9point {9point} {H/V testing} }
	{ {cardinal calibration} setup_cardinal {cardinal} {H/V testing} }
	{ {24point calibration} setup_24point {24point} {H/V testing} }
    }

    # ---------------------------------------------------------------------
    # Default init and destroy procs (copy and edit to make variant specific)
     proc default_init { } {
        setBackground 128 128 128
#	::load bink
#	::load light
#	::load polygon
	set ::cur_namespace [namespace current]
     }
     proc default_destroy { } {
 	# nothing to do
     }

    # ---------------------------------------------------------------------
    # Variant specific init and destroy procs (must occur as a set!)


    # ---------------------------------------------------------------------
    # Shared Procs

}
